﻿let currentOperation = '';
let endpoint = '';

// Показать список заказов для выбранной операции
async function showOrders(operation) {
    currentOperation = operation;

    try {
        // Показываем загрузку
        document.getElementById('ordersContainer').innerHTML = '<div class="loading">Загрузка заказов...</div>';
        document.getElementById('ordersList').style.display = 'block';

        // Устанавливаем заголовок в зависимости от операции
        const title = document.getElementById('ordersListTitle');
        endpoint = '';

        switch (operation) {
            case 're-add-payment':
                title.textContent = 'Выберите заказ для перепроведения платежа';
                endpoint = 'readd';
                break;

            case 'refund':
                title.textContent = 'Выберите заказ для возврата';
                endpoint = 'refund';
                break;

            case 'repeated-refund':
                title.textContent = 'Выберите заказ для повторного возврата';
                endpoint = 'repeated-refund';
                break;

            default:
                console.warn(`Неизвестная операция: ${operation}`);
                title.textContent = 'Выберите заказ';
                endpoint = '';
                break;
        }

        // Загружаем заказы с сервера
        const response = await fetch('/api/orders/' + endpoint, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json'
            }
        });

        const result = await response.json();

        if (result.Success && result.Data && result.Data.length > 0) {
            displayOrders(result.Data);
        } else {
            document.getElementById('ordersContainer').innerHTML =
                '<div class="no-orders">Заказы не найдены</div>';
        }
    } catch (error) {
        console.error('Error loading orders:', error);
        document.getElementById('ordersContainer').innerHTML =
            '<div class="error">Ошибка при загрузке заказов</div>';
    }
}


// Скрыть список заказов
function hideOrdersList() {
    document.getElementById('ordersList').style.display = 'none';
    currentOperation = '';
}

// Отобразить список заказов
function displayOrders(orders) {
    const container = document.getElementById('ordersContainer');

    const ordersHtml = orders.map(order => `
        <div class="order-item" onclick="processOrder('${order.Id}')">
            <div class="order-number">Заказ #${order.Number}</div>
            <div class="order-info">
                <span>ID: ${order.Id}</span>
                <span class="order-status status-${order.Status}">${getStatusText(order.Status)}</span>
            </div>
        </div>
    `).join('');

    container.innerHTML = ordersHtml;
}

// Обработать выбранный заказ
async function processOrder(orderId) {
    if (!currentOperation) return;
    console.log('currentOperation:', currentOperation);
    console.log('endpoint:', endpoint);
    const {isConfirmed} = await Swal.fire({
        title: 'Подтверждение',
        text: `Вы уверены, что хотите выполнить операцию "${getOperationName(currentOperation)}" для выбранного заказа?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Да',
        cancelButtonText: 'Отмена',
    });

    if (!isConfirmed) return;

    try {
        const response = await fetch(`/api/orders/${endpoint}`, {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({id: orderId})
        });

        const result = await response.json();

        if (result.Success) {
            if (result.Code || (result.Data && result.Data.Code)) {
                const code = result.Code || result.Data.Code;

                await Swal.fire({
                    title: 'Код для возврата',
                    html: `
                        <div style="font-size: 1.2rem; margin-top: 10px;">
                            Введите этот код на киоске для подтверждения возврата:
                        </div>
                        <div style="
                            font-size: 2rem;
                            font-weight: bold;
                            margin-top: 15px;
                            color: #007bff;
                            letter-spacing: 3px;">
                            ${code}
                        </div>
                    `,
                    icon: 'info',
                    confirmButtonText: 'Понятно'
                });
            } else {
                // обычный успех без кода
                await Swal.fire({
                    title: 'Успешно',
                    text: `Операция "${getOperationName(currentOperation)}" для заказа выполнена успешно`,
                    icon: 'success'
                });
            }

            hideOrdersList();
        } else {
            await Swal.fire({
                title: 'Ошибка',
                text: result.Message || 'Неизвестная ошибка',
                icon: 'error'
            });
        }
    } catch (error) {
        console.error('API call error:', error);
        await Swal.fire({
            title: 'Ошибка',
            text: 'Ошибка при выполнении операции',
            icon: 'error'
        });
    }
}

/*async function processOrder(orderId) {
    if (!currentOperation) return;

    const {isConfirmed} = await Swal.fire({
        title: 'Подтверждение',
        text: `Вы уверены, что хотите выполнить операцию "${getOperationName(currentOperation)}" для выбранного заказа?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Да',
        cancelButtonText: 'Отмена',
    });

    if (!isConfirmed) return;

    try {
        const response = await fetch(`/api/orders/${endpoint}`, {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({id: orderId})
        });

        const result = await response.json();

        if (result.Success) {
            await Swal.fire({
                title: 'Успешно',
                text: `Операция "${getOperationName(currentOperation)}" для заказа выполнена успешно`,
                icon: 'success'
            });
            hideOrdersList();
        } else {
            await Swal.fire({
                title: 'Ошибка',
                text: result.Message || 'Неизвестная ошибка',
                icon: 'error'
            });
        }
    } catch (error) {
        console.error('API call error:', error);
        await Swal.fire({
            title: 'Ошибка',
            text: 'Ошибка при выполнении операции',
            icon: 'error'
        });
    }
}*/


// Вспомогательные функции
function getOperationName(operation) {
    const names = {
        're-add-payment': 'Перевод платежа в заказ',
        'refund': 'Возврат',
        'repeated-refund' : 'Повторный возврат'
    };
    return names[operation] || operation;
}

function getStatusText(status) {
    const statuses = {
        'ReAddPayment':'Новый',
        'New': 'Новый',
        'Refund': 'Закрыт',
        'RepeatedRefund': 'Удален'
    };
    return statuses[status] || status;
}