// wwwroot/js/app.js
class DashboardManager {
    constructor() {
        this.init();
    }

    init() {

        this.loadSystemInfo();
        setInterval(() => {
            this.loadSystemInfo();
        }, 10000);
       // this.loadRecentOrders();
       // this.startAutoUpdate();
    }

    async loadRecentOrders() {
        try {
            const response = await fetch('/api/orders');
            const result = await response.json();
            
            if (result.success && result.data) {
                this.displayRecentOrders(result.data.slice(0, 5)); // Показываем 5 последних
            }
        } catch (error) {
            console.error('Error loading recent orders:', error);
            document.getElementById('recentOrders').innerHTML = 
                '<div class="error">Ошибка загрузки заказов</div>';
        }
    }

    displayRecentOrders(orders) {
        const container = document.getElementById('recentOrders');
        
        if (orders.length === 0) {
            container.innerHTML = '<div class="no-orders">Нет recent orders</div>';
            return;
        }

        const ordersHtml = orders.map(order => `
            <div class="recent-order-item">
                <div class="recent-order-number">${order.number}</div>
                <div class="recent-order-customer">${order.customer}</div>
                <div class="recent-order-amount">${order.amount.toFixed(2)} руб.</div>
                <div class="recent-order-status ${order.status.toLowerCase()}">${order.status}</div>
            </div>
        `).join('');

        container.innerHTML = ordersHtml;
    }

    startAutoUpdate() {
        // Обновляем время каждую минуту
        setInterval(() => {
            this.updateLastUpdateTime();
        }, 60000);

        // Обновляем заказы каждые 2 минуты
        setInterval(() => {
            this.loadRecentOrders();
        }, 120000);
    }

    async loadSystemInfo() {
        try {
            const response = await fetch('/api/system');
            const result = await response.json();

            if (result.Success) {
                this.updateSystemInfo(result.Data);
            } else {
                this.showError('Не удалось загрузить системную информацию');
            }
        } catch (error) {
            console.error('Error loading system info:', error);
            this.showError('Ошибка при загрузке системной информации');
        }
    }

    updateSystemInfo(systemInfo) {
        // Обновляем количество киосков
        const kiosksElement = document.getElementById('kiosksCount');
        if (kiosksElement) {
            kiosksElement.textContent = systemInfo.KiosksCount;
        }

        // Обновляем статус кассовой смены
        const sessionElement = document.getElementById('cashSessionStatus');
        if (sessionElement) {
            sessionElement.textContent = systemInfo.IsCaffeSessionOpened ? 'Открыта' : 'Закрыта';
            sessionElement.className = systemInfo.IsCaffeSessionOpened ? 'status-value status-active' : 'status-value';
        }

        // Обновляем время последнего обновления меню
        const lastUpdateElement = document.getElementById('lastUpdate');
        if (lastUpdateElement) {
            lastUpdateElement.textContent = systemInfo.LastUpdatedMenu;
        }
    }

    showError(message) {
        console.error(message);
        // Можно добавить уведомление пользователю
        const lastUpdateElement = document.getElementById('lastUpdate');
        if (lastUpdateElement) {
            lastUpdateElement.textContent = 'Ошибка загрузки';
        }
    }
}

// Инициализация dashboard при загрузке страницы
document.addEventListener('DOMContentLoaded', () => {
    new DashboardManager();
});