﻿async function systemApiCall(operation) {
    if (!confirm(`Вы уверены, что хотите выполнить операцию "${getOperationName(operation)}"?`)) {
        return;
    }

    try {
        const actionType = getActionType(operation);

        const response = await fetch('/api/system', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                action: actionType
            })
        });

        const result = await response.json();

        if (result.Success) {
            alert(`Операция "${getOperationName(operation)}" выполнена успешно`);
        } else {
            alert(`Ошибка: ${result.Message || 'Неизвестная ошибка'}`);
        }
    } catch (error) {
        console.error('API call error:', error);
        alert('Ошибка при выполнении операции');
    }
}

function getActionType(operation) {
    const actionMap = {
        'reload-plugin': 'RebootPlugin',
        'reopen-session': 'ReopenCafeSession',
        'update-menu': 'UpdateMenu',
        'update-settings': 'UpdateSettings'
    };
    return actionMap[operation] || operation;
}

function getOperationName(operation) {
    const names = {
        'reload-plugin': 'Перезагрузка плагина',
        'reopen-session': 'Переоткрытие смены',
        'update-menu': 'Обновление меню',
        'update-settings': 'Обновление настроек'
    };
    return names[operation] || operation;
}