﻿let currentKioskOperation = '';

// Показать список киосков для выбранной операции
async function showKiosks(operation) {
    currentKioskOperation = operation;

    try {
        // Показываем загрузку
        document.getElementById('kiosksContainer').innerHTML = '<div class="loading">Загрузка киосков...</div>';
        document.getElementById('kiosksList').style.display = 'block';

        // Устанавливаем заголовок в зависимости от операции
        const title = document.getElementById('kiosksListTitle');
        title.textContent = getKioskOperationName(operation);

        // Загружаем киоски с сервера
        const response = await fetch('/api/kiosks', {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json'
            }
        });

        const result = await response.json();

         if (result.Success && result.Data && result.Data.length > 0) {
            displayKiosks(result.Data);
        } else {
            document.getElementById('kiosksContainer').innerHTML =
                '<div class="no-data">Киоски не найдены</div>';
        }
    } catch (error) {
        console.error('Error loading kiosks:', error);
        document.getElementById('kiosksContainer').innerHTML =
            '<div class="error">Ошибка при загрузке киосков</div>';
    }
}

// Скрыть список киосков
function hideKiosksList() {
    document.getElementById('kiosksList').style.display = 'none';
    currentKioskOperation = '';
}

// Отобразить список киосков
function displayKiosks(kiosks) {
    const container = document.getElementById('kiosksContainer');

    const kiosksHtml = kiosks.map(kiosk => `
        <div class="kiosk-item" onclick="processKiosk('${kiosk.ConnectionId}', '${kiosk.Status}', '${kiosk.Name}')">
            <div class="kiosk-header">
                <span class="kiosk-name">${kiosk.Name || 'Киоск'}</span>
                <span class="kiosk-status status-${kiosk.Status === 'Active' || kiosk.Status === 'Активен' ? 'active' : 'disabled'}">
                    ${kiosk.Status}
                </span>
            </div>
            <div class="kiosk-info">
                <div class="kiosk-detail">
                    <span class="detail-label">ID киоска:</span>
                    <span class="detail-value">${kiosk.Id || 'Не указан'}</span>
                </div>
                <div class="kiosk-detail">
                    <span class="detail-label">ID подключения:</span>
                    <span class="detail-value">${kiosk.ConnectionId}</span>
                </div>
                <div class="kiosk-detail">
                    <span class="detail-label">Статус:</span>
                    <span class="detail-value status-badge status-${kiosk.Status === 'Active' || kiosk.Status === 'Активен' ? 'active' : 'disabled'}">
                        ${kiosk.Status}
                    </span>
                </div>
            </div>
            <div class="kiosk-action">
                ${currentKioskOperation === 'service_mode' ? getKioskStatusActionButtonText(kiosk.Status) : getKioskActionButtonText() }
            </div>
        </div>
    `).join('');

    container.innerHTML = kiosksHtml;
}

// Обработать выбранный киоск
async function processKiosk(connectionId, status, name) {
    if (!currentKioskOperation) return;

    const action = status === 'Active' || status === 'Активен' ? 'отключить' : 'включить';
    var conformationText = '';
    if (currentKioskOperation === "service_mode") {
        conformationText = `Вы уверены, что хотите ${action} киоск "${name}"?`;
    }
    else {
        conformationText = `Вы уверены, что хотите отправить сигнал на переоткрытие смены на киоск "${name}"?`;
    }

    if (!confirm(conformationText)) return;

    try {
        const response = await fetch(`/api/kiosks/${currentKioskOperation}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                connectionId: connectionId
            })
        });

        const result = await response.json();

        if (result) {
            if (currentKioskOperation === "service_mode") {
                alert(`Статус киоска "${name}" успешно изменен`);
            }
            else {
                alert(`Сигнал на киоск "${name}" успешно отправлен`);
            }
            // Обновляем список киосков
            showKiosks(currentKioskOperation);
        } else {
            alert('Ошибка при обработке запроса');
        }
    } catch (error) {
        console.error('API call error:', error);
        alert('Ошибка при выполнении операции');
    }
}

// Получить текст для кнопки действия
function getKioskStatusActionButtonText(status) {
    if (status === 'Active' || status === 'Активен') {
        return '<span class="action-text">Нажмите чтобы перевести в сервисный режим</span>';
    } else {
        return '<span class="action-text">Нажмите чтобы включить киоск</span>';
    }
}
function getKioskActionButtonText() {
    if (currentKioskOperation === 'reopen_session') {
        return '<span class="action-text">Нажмите чтобы переоткрыть смену</span>';
    }
    return `<span class="action-text">Нажмите чтобы ${currentKioskOperation}</span>`;
}

// Вспомогательные функции
function getKioskOperationName(operation) {
    const names = {
        'service_mode': 'Управление сервисным режимом киосков',
        'reopen_session': "Управление кассовыми сменами киосков"
    };
    return names[operation] || operation;
}

// Функция для вызова из HTML (сервисный режим)
function toggleServiceMode(mode) {
    showKiosks(mode);
}

// Автоматическая загрузка киосков при загрузке страницы (опционально)
document.addEventListener('DOMContentLoaded', function () {
    // Можно автоматически загрузить киоски при открытии страницы
    // showKiosks('service_mode');
});